﻿using System;
using Soneta.Types;
using Soneta.Business;
using Soneta.Core;
using Soneta.SrodkiTrwale;
using Soneta.Web;
using System.Collections;

namespace ASP
{
    public partial class WartosciSrodkowTrwalych : System.Web.UI.Page
    {
        public static string Str_Grupa = "Grupa";
        public static string Str_Tytul = "Wartości środków trwałych";
        public static string Str_Oddzial = "Oddział";
        public static string Str_RazemDostepne = "Razem dostępne";
        public static string Str_DateFmt = "dd.MM.yy";
        public static string Str_WartoscB = "Wartość na {0} (B)";
        public static string Str_WartoscP = "Wartość na {0} (P)";
        public static string Str_UmorzenieB = "Umorzenie na {0} (B)";
        public static string Str_UmorzenieP = "Umorzenie na {0} (P)";


        SrodkiTrwale.Params p = null;
        Soneta.Types.DictionaryAuto<OddzialProxy, System.Collections.Generic.List<Item>> wgOddzialow = new DictionaryAuto<OddzialProxy, System.Collections.Generic.List<Item>>();

        protected void DataRepeater1_BeforeRow(object sender, EventArgs args)
        {
            OddzialProxy odd = (OddzialProxy)((DataRepeater)sender).CurrentRow;
            DataLabelOddzial.EditValue = odd.Oddzial == null ? "" : odd.Oddzial.ToString();

            wgOddzialow[odd].Sort(ComapreItems);
            if (param.WgGrup)
            {
                System.Collections.Generic.Dictionary<string, GrupaItem> wgGrup = new System.Collections.Generic.Dictionary<string, GrupaItem>();
                foreach (SrodekItem si in wgOddzialow[odd])
                {
                    if (!wgGrup.ContainsKey(si.Grupa))
                        wgGrup.Add(si.Grupa, new GrupaItem(si.Grupa));
                    wgGrup[si.Grupa].Add(si);
                }
                if (Grid1.Columns.Contains(colNazwa))
                {
                    Grid1.ShowGroupSum = false;
                    Grid1.GroupLine = "";
                    Grid1.GroupData0 = "";
                    colSymbol.Caption = Str_Grupa;
                    colSymbol.RowSpan = prm.TylkoWartosciBilansowe ? 1 : 2;
                    colSymbol.Width = 10;
                    Grid1.Columns.Remove(colNazwa);
                    Grid1.Columns.Remove(colUzytkowanie);
                    Grid1.Columns.Remove(colLikwidacja);
                }
                Grid1.DataSource = wgGrup.Values;
            }
            else
                Grid1.DataSource = new ArrayList(wgOddzialow[odd]);
        }

        protected void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args)
        {
        }

        protected void WartosciSrodkowTrwalych_OnLoad(Object sender, EventArgs args)
        {
            p = (SrodkiTrwale.Params)DataContext1.Get(typeof(SrodkiTrwale.Params));

            ReportHeader1.Title = Str_Tytul + p.GetReportParametersDescription();

            if (param.WgOddzialow)
                ReportHeader1.Title += string.Format("|</STRONG>" + Str_Oddzial + ":<STRONG> {0}",
                  param.OddzialItem.type == OddziałItemType.RazemDostępne ? Str_RazemDostepne : param.OddzialItem.Kod);
            OddzialProxy oddNull = new OddzialProxy(null);

            foreach (SrodekTrwalyBase s in (Row[])DataContext1.Get(typeof(Row[])))
            {
                SrodekTrwalyBaseHistoria sh = s[p.Aktualnosc];
                if (s.DataRejestracji == Date.Empty || s.DataRejestracji > p.Aktualnosc)
                    continue;
                OddzialFirmy o = (!param.WgOddzialow || sh.MiejsceUzytkowania == null) ? null : sh.MiejsceUzytkowania.Oddzial;
                OddzialProxy odd = null;
                if (o == null)
                    odd = oddNull;
                else
                    odd = new OddzialProxy(o);

                Date aktualnoscBO = p.Aktualnosc.FirstDayYear();
                SrodekTrwalyBaseHistoria shbo = s[aktualnoscBO];
                OddzialFirmy obo = (!param.WgOddzialow || shbo.MiejsceUzytkowania == null) ? null : shbo.MiejsceUzytkowania.Oddzial;
                OddzialProxy oddbo = null;
                if (obo == null)
                    oddbo = oddNull;
                else
                    oddbo = new OddzialProxy(obo);

                if (!param.ZeZmianamiMiescjaUzytkowania || obo == o)
                {
                    if (param.CheckOddzial(odd))
                        wgOddzialow[odd].Add(new SrodekItem(sh, p.Aktualnosc, null, false));
                }
                else
                {
                    SrodekItem sibo = new SrodekItem(shbo, aktualnoscBO, null, true);
                    if (param.CheckOddzial(oddbo))
                        wgOddzialow[oddbo].Add(sibo);
                    if (param.CheckOddzial(odd))
                        wgOddzialow[odd].Add(new SrodekItem(sh, p.Aktualnosc, sibo, false));
                }
            }


            FromTo okres = new FromTo(new Date(p.Aktualnosc.Year, 1, 1), new Date(p.Aktualnosc.Year, 12, 31));
            if (SrodkiTrwaleModule.GetInstance(p).Config.Ogólne.UwzględniajKontekstOkresuObrach)
            {
                IOkresObrachunkowyService oos = null;
                p.Session.GetService<IOkresObrachunkowyService>(out oos);
                if (oos != null)
                    okres = oos.OkresWgDaty(p.Aktualnosc);
            }

            String okresPoczatekStr = okres.From.ToString("dd.MM.yy");
            colWartosc01B.Caption = String.Format(Str_WartoscB, okresPoczatekStr);
            colWartosc01P.Caption = String.Format(Str_WartoscP, okresPoczatekStr);
            colOdpisy01B.Caption = String.Format(Str_UmorzenieB, okresPoczatekStr);
            colOdpisy01P.Caption = String.Format(Str_UmorzenieP, okresPoczatekStr);


            DataRepeater1.DataContext = DataContext1;
            DataRepeater1.DataSource = wgOddzialow.Keys;



            if (prm.TylkoWartosciBilansowe)
            {
                Grid1.RowsInRow = 1;
                colSymbol.Width = 0;
                colUzytkowanie.Visible = false;
                colLikwidacja.Visible = false;
                colWartoscPoczatkowaP.Visible = false;
                colWartosc01P.Visible = false;
                colZwiekszeniaWartoscP.Visible = false;
                colZmniejszeniaWartoscP.Visible = false;
                colWartoscP.Visible = false;
                colOdpisyAktualizujaceP.Visible = false;
                colOdpisy01P.Visible = false;
                colZwiekszeniaOdpisyP.Visible = false;
                colZmniejszeniaOdpisyP.Visible = false;
                colOdpisyP.Visible = false;
                colWartoscNettoP.Visible = false;
            }
        }

        public class OddzialProxy
        {
            readonly public OddzialFirmy Oddzial;
            public OddzialProxy(OddzialFirmy oddzial)
            {
                Oddzial = oddzial;
            }

            public override int GetHashCode()
            {
                return (Oddzial == null) ? base.GetHashCode() : Oddzial.GetHashCode();
            }

            public override bool Equals(object obj)
            {
                OddzialProxy op = (OddzialProxy)obj;
                return op.Oddzial == this.Oddzial;
            }
        }

        int ComapreItems(Item x, Item y)
        {
            int ret = string.Compare(x.Grupa, y.Grupa);
            if (ret != 0)
                return ret;
            return string.Compare(x.Symbol, y.Symbol);
        }


        abstract public class Item
        {
            public Item(string symbol, string nazwa, string grupa)
            {
                this.symbol = symbol;
                this.nazwa = nazwa;
                this.grupa = grupa;
            }

            public Item(string symbol, string nazwa, string grupa, Date rejestracja, Date uzytkowanie, Date likwidacja)
            {
                this.symbol = symbol;
                this.nazwa = nazwa;
                this.grupa = grupa;
                this.rejestracja = rejestracja;
                this.uzytkowanie = uzytkowanie;
                this.likwidacja = likwidacja;
            }

            protected readonly string symbol;
            public string Symbol
            {
                get { return symbol; }
            }

            protected readonly string nazwa;
            public string Nazwa
            {
                get { return nazwa; }
            }

            protected readonly string grupa;
            public string Grupa
            {
                get { return grupa; }
            }



            protected readonly Date rejestracja;
            public Date Rejestracja
            {
                get { return rejestracja; }
            }
            protected readonly Date uzytkowanie;
            public Date Uzytkowanie
            {
                get { return uzytkowanie; }
            }

            protected readonly Date likwidacja;
            public Date Likwidacja
            {
                get { return likwidacja; }
            }

            protected decimal wartoscPoczatkowaB;
            public decimal WartoscPoczatkowaB
            {
                get { return wartoscPoczatkowaB; }
            }

            protected decimal wartoscPoczatkowaP;
            public decimal WartoscPoczatkowaP
            {
                get { return wartoscPoczatkowaP; }
            }

            protected decimal wartoscBrutto01B;
            public decimal WartoscBrutto01B
            {
                get { return wartoscBrutto01B; }
            }

            protected decimal wartoscBrutto01P;
            public decimal WartoscBrutto01P
            {
                get { return wartoscBrutto01P; }
            }

            protected decimal wartoscBruttoZwiekszeniaB;
            public decimal WartoscBruttoZwiekszeniaB
            {
                get { return wartoscBruttoZwiekszeniaB; }
            }

            protected decimal wartoscBruttoZwiekszeniaP;
            public decimal WartoscBruttoZwiekszeniaP
            {
                get { return wartoscBruttoZwiekszeniaP; }
            }

            protected decimal wartoscBruttoZmniejszeniaB;
            public decimal WartoscBruttoZmniejszeniaB
            {
                get { return wartoscBruttoZmniejszeniaB; }
            }

            protected decimal wartoscBruttoZmniejszeniaP;
            public decimal WartoscBruttoZmniejszeniaP
            {
                get { return wartoscBruttoZmniejszeniaP; }
            }

            protected decimal wartoscBruttoB;
            public decimal WartoscBruttoB
            {
                get { return wartoscBruttoB; }
            }

            protected decimal wartoscBruttoP;
            public decimal WartoscBruttoP
            {
                get { return wartoscBruttoP; }
            }

            protected decimal odpisyAktualizujaceB;
            public decimal OdpisyAktualizujaceB
            {
                get { return odpisyAktualizujaceB; }
            }

            protected decimal odpisyAktualizujaceP;
            public decimal OdpisyAktualizujaceP
            {
                get { return odpisyAktualizujaceP; }
            }


            protected decimal odpisy01B;
            public decimal Odpisy01B
            {
                get { return odpisy01B; }
            }

            protected decimal odpisy01P;
            public decimal Odpisy01P
            {
                get { return odpisy01P; }
            }

            protected decimal odpisyZwiekszeniaB;
            public decimal OdpisyZwiekszeniaB
            {
                get { return odpisyZwiekszeniaB; }
            }

            protected decimal odpisyZwiekszeniaP;
            public decimal OdpisyZwiekszeniaP
            {
                get { return odpisyZwiekszeniaP; }
            }

            protected decimal odpisyZmniejszeniaB;
            public decimal OdpisyZmniejszeniaB
            {
                get { return odpisyZmniejszeniaB; }
            }

            protected decimal odpisyZmniejszeniaP;
            public decimal OdpisyZmniejszeniaP
            {
                get { return odpisyZmniejszeniaP; }
            }

            protected decimal odpisyB;
            public decimal OdpisyB
            {
                get { return odpisyB; }
            }

            protected decimal odpisyP;
            public decimal OdpisyP
            {
                get { return odpisyP; }
            }

            protected decimal wartoscNettoB;
            public decimal WartoscNettoB
            {
                get { return wartoscNettoB; }
            }

            protected decimal wartoscNettoP;
            public decimal WartoscNettoP
            {
                get { return wartoscNettoP; }
            }
        }

        public class SrodekItem : Item
        {
            public SrodekItem(SrodekTrwalyBaseHistoria sh, Date aktualnosc, SrodekItem bo, bool liczTylkoBO)
                : base(sh.Srodek.NumerInwentarzowy, sh.Srodek.Nazwa, sh.KRST.GrupaSymbol, sh.Srodek.DataRejestracji, sh.Srodek.DataRozpoczeciaUzytkowania, sh.Srodek.DataLikwidacji)

            {
                WartosciSrodkaWorker wsw = SrodekItem.WSW;
                wsw.Data = aktualnosc;
                wsw.SrodekHistoria = sh;

                if (liczTylkoBO)
                {
                    wartoscPoczatkowaB = wsw.WartoscPoczatkowaBilansowa.Value;
                    wartoscPoczatkowaP = wsw.WartoscPoczatkowaPodatkowa.Value;
                    wartoscBrutto01B = wsw.Wartosc01Bilansowa.Value;
                    wartoscBrutto01P = wsw.Wartosc01Podatkowa.Value;
                    odpisy01B = wsw.Odpisy01Bilansowe.Value;
                    odpisy01P = wsw.Odpisy01PodatkoweZUlgami.Value;
                    wartoscBruttoZmniejszeniaB = -wartoscBrutto01B;
                    wartoscBruttoZmniejszeniaP = -wartoscBrutto01P;
                    odpisyZmniejszeniaB = -odpisy01B;
                    odpisyZmniejszeniaP = -odpisy01P;
                }
                else
                {
                    wartoscPoczatkowaB = bo == null ? wsw.WartoscPoczatkowaBilansowa.Value : 0m;
                    wartoscPoczatkowaP = bo == null ? wsw.WartoscPoczatkowaPodatkowa.Value : 0m;
                    wartoscBrutto01B = bo == null ? wsw.Wartosc01Bilansowa.Value : 0m;
                    wartoscBrutto01P = bo == null ? wsw.Wartosc01Podatkowa.Value : 0m;
                    wartoscBruttoZwiekszeniaB = wsw.WartoscBilansowaZwiekszeniaBiezace.Value;
                    wartoscBruttoZwiekszeniaP = wsw.WartoscPodatkowaZwiekszeniaBiezace.Value;
                    if (bo != null)
                    {
                        wartoscBruttoZwiekszeniaB += -bo.WartoscBruttoZmniejszeniaB;
                        wartoscBruttoZwiekszeniaP += -bo.WartoscBruttoZmniejszeniaP;
                    }
                    wartoscBruttoZmniejszeniaB = wsw.WartoscBilansowaZmniejszeniaBiezace.Value;
                    wartoscBruttoZmniejszeniaP = wsw.WartoscPodatkowaZmniejszeniaBiezace.Value;
                    wartoscBruttoB = wsw.WartoscBilansowa.Value;
                    wartoscBruttoP = wsw.WartoscPodatkowa.Value;

                    odpisyAktualizujaceB = wsw.OdpisyAktualizująceBilansowe.Value;
                    odpisyAktualizujaceP = wsw.OdpisyAktualizującePodatkowe.Value;

                    odpisy01B = bo == null ? wsw.Odpisy01Bilansowe.Value : 0m;
                    odpisy01P = bo == null ? wsw.Odpisy01PodatkoweZUlgami.Value : 0m;
                    odpisyZwiekszeniaB = wsw.OdpisyBilansoweZwiekszeniaBiezace.Value;
                    odpisyZwiekszeniaP = wsw.OdpisyPodatkoweZwiekszeniaZUlgamiBiezace.Value;

                    if (bo != null)
                    {
                        odpisyZwiekszeniaB += -bo.OdpisyZmniejszeniaB;
                        odpisyZwiekszeniaP += -bo.OdpisyZmniejszeniaP;
                    }

                    odpisyZmniejszeniaB = wsw.OdpisyBilansoweZmniejszeniaBiezace.Value;
                    odpisyZmniejszeniaP = wsw.OdpisyPodatkoweZmniejszeniaBiezace.Value;
                    odpisyB = wsw.OdpisyBilansowe.Value;
                    odpisyP = wsw.OdpisyPodatkoweZUlgami.Value;
                    wartoscNettoB = wsw.WartoscBilansowaNetto.Value;
                    wartoscNettoP = wsw.WartoscPodatkowaNettoZUlgami.Value;
                }

            }

            static WartosciSrodkaWorker wsw = null;
            static public WartosciSrodkaWorker WSW
            {
                get
                {
                    lock (typeof(SrodekItem))
                    {
                        if (wsw != null)
                            return wsw;
                        wsw = new WartosciSrodkaWorker();
                    }
                    return wsw;
                }
            }
        }

        public class GrupaItem : Item
        {
            public GrupaItem(string grupa)
                : base(grupa, grupa, grupa)
            {
            }

            internal void Add(SrodekItem si)
            {
                wartoscPoczatkowaB += si.WartoscPoczatkowaB;
                wartoscPoczatkowaP += si.WartoscPoczatkowaP;
                wartoscBrutto01B += si.WartoscBrutto01B;
                wartoscBrutto01P += si.WartoscBrutto01P;
                wartoscBruttoZwiekszeniaB += si.WartoscBruttoZwiekszeniaB;
                wartoscBruttoZwiekszeniaP += si.WartoscBruttoZwiekszeniaP;
                wartoscBruttoZmniejszeniaB += si.WartoscBruttoZmniejszeniaB;
                wartoscBruttoZmniejszeniaP += si.WartoscBruttoZmniejszeniaP;
                wartoscBruttoB += si.WartoscBruttoB;
                wartoscBruttoP += si.WartoscBruttoP;
                odpisyAktualizujaceB += si.OdpisyAktualizujaceB;
                odpisyAktualizujaceP += si.OdpisyAktualizujaceP;
                odpisy01B += si.Odpisy01B;
                odpisy01P += si.Odpisy01P;
                odpisyZwiekszeniaB += si.OdpisyZwiekszeniaB;
                odpisyZwiekszeniaP += si.OdpisyZwiekszeniaP;
                odpisyZmniejszeniaB += si.OdpisyZmniejszeniaB;
                odpisyZmniejszeniaP += si.OdpisyZmniejszeniaP;
                odpisyB += si.OdpisyB;
                odpisyP += si.OdpisyP;
                wartoscNettoB += si.WartoscNettoB;
                wartoscNettoP += si.WartoscNettoP;
            }
        }

        Params param = null;
        [Context]
        public Params Param
        {
            set { param = value; }
        }

        public class Params : ContextBase
        {
            Soneta.Core.OddzialParamsBase oddzialParams = null;

            public Params(Context cx)
                : base(cx)
            {
                if (cx.Contains(typeof(Soneta.Core.OddzialParamsBase)))
                    oddzialParams = (Soneta.Core.OddzialParamsBase)cx[typeof(Soneta.Core.OddzialParamsBase)];
                else
                    oddzialParams = new OddzialParamsBase(cx);
                oddzialItem = oddzialParams.Oddział;
            }

            bool wgGrup = false;
            [Caption("Wg grup")]
            [Soneta.Tools.Priority(1)]
            public bool WgGrup
            {
                get { return wgGrup; }
                set { wgGrup = value; OnChanged(EventArgs.Empty); }
            }

            bool wgOddzialow = false;
            [Caption("Wg oddziałów")]
            [Soneta.Tools.Priority(202)]
            public bool WgOddzialow
            {
                get { return wgOddzialow; }
                set
                {
                    wgOddzialow = zeZmianamiMiescjaUzytkowania = value;
                    oddzialItem = oddzialParams.Oddział;
                    OnChanged(EventArgs.Empty);
                }
            }

            public bool IsReadOnlyWgOddzialow()
            {
                return !oddzialParams.OddzialowoscEnabled;
            }

            Soneta.Core.OddziałItem oddzialItem = null;
            [Soneta.Tools.Priority(203)]
            [Caption("Oddział")]
            public Soneta.Core.OddziałItem OddzialItem
            {
                get { return oddzialItem; }
                set { oddzialItem = value; OnChanged(EventArgs.Empty); }
            }

            public object GetListOddzialItem()
            {
                System.Collections.Generic.List<OddziałItem> list = new System.Collections.Generic.List<OddziałItem>();
                foreach (OddziałItem oi in (IEnumerable)oddzialParams.GetListOddział())
                    if (oi.type == OddziałItemType.Oddział || oi.type == OddziałItemType.RazemDostępne)
                        list.Add(oi);
                return list;
            }

            public bool IsReadOnlyOddzialItem()
            {
                return !wgOddzialow;
            }

            bool zeZmianamiMiescjaUzytkowania = false;
            [Caption("Zmiany miejsca użytk.")]
            [Soneta.Tools.Priority(204)]
            public bool ZeZmianamiMiescjaUzytkowania
            {
                get { return zeZmianamiMiescjaUzytkowania; }
                set { zeZmianamiMiescjaUzytkowania = value; OnChanged(EventArgs.Empty); }
            }

            public bool IsReadOnlyZeZmianamiMiescjaUzytkowania()
            {
                return !WgOddzialow;
            }

            public bool CheckOddzial(OddzialProxy proxy)
            {
                switch (oddzialItem.type)
                {
                    case OddziałItemType.RazemDostępne:
                        return true;
                    case OddziałItemType.Oddział:
                        return proxy.Oddzial != null && proxy.Oddzial == (OddzialFirmy)oddzialItem.ptr;
                    default:
                        return false;
                }
            }
        }

        TylkoWartosciBilansowePrm prm = null;

        [Context]
        public TylkoWartosciBilansowePrm Prm
        { set { prm = value; } }
    }
}


